#include <simpleplot.h>
#include <nn.h>

extern nn* nn1;

double NeuralNetwork::operator()(double x, double y)
{
    return nn1->get_3d(x,y);
}

void NeuralNetwork::set_domain(double minu,double maxu,
			       double minv,double maxv,
			       double minz)
{
   setDomain(minu,maxu,minv,maxv);
   setMinZ(minz);
}

Plot::Plot(QWidget* parent, double xmin, double xmax
	   , double ymin, double ymax, bool flag)
    :SurfacePlot (parent)
  {
    setTitle("3D-View of neural net");
    double s_min,s_max;
    if(flag==true){
	s_min=(nn1->get_min(nn1->get_y_output()));
	s_max=(nn1->get_max(nn1->get_y_output()));
    }
    else
	s_min=0;
    NeuralNetwork nn2(*this);
    nn2.set_domain(xmin,xmax,ymin,ymax,s_min-1);
    nn2.setMesh(41,31);
    
    nn2.create();

    setRotation(30,0,15);
    setScale(1,1,1);
    setShift(0.15,0,0);
    setZoom(0.9);

    for (unsigned i=0; i!=coordinates()->axes.size(); ++i)
    {
      coordinates()->axes[i].setMajors(7);
      coordinates()->axes[i].setMinors(4);
    }


    coordinates()->axes[X1].setLabelString("x");
    coordinates()->axes[Y1].setLabelString("y");
    coordinates()->axes[Z1].setLabelString("z"); 

    setCoordinateStyle(BOX);

    updateData();
    updateGL();
  }

